---
generated_at: 2026-02-03 10:45:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：20-Multi Term Vectors

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **TransportMultiTermVectorsActionの並列実行動作**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `rest-api-spec/src/main/resources/rest-api-spec/api/mtermvectors.json`
- E-02: `server/src/main/java/org/opensearch/rest/action/document/RestMultiTermVectorsAction.java`
- E-03: `server/src/main/java/org/opensearch/rest/action/document/RestTermVectorsAction.java`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 4つのルート定義（GET/POST x 2パス） | E-01, E-02 (行59-66) | ○ |
| C-02 | テンプレートTermVectorsRequestの構築 | E-02 (行78) | ○ |
| C-03 | RestTermVectorsAction.readURIParameters()の再利用 | E-02 (行80), E-03 (行94) | ○ |
| C-04 | idsパラメータの解析 | E-02 (行81), E-01 (params.ids) | ○ |
| C-05 | withContentOrSourceParamParserOrNull()によるボディパース | E-02 (行82) | ○ |
| C-06 | MultiTermVectorsRequest.add(template, parser) | E-02 (行82) | ○ |
| C-07 | NodeClient.multiTermVectors()の呼び出し | E-02 (行84) | ○ |
| C-08 | RestToXContentListenerの使用 | E-02 (行84) | ○ |
| C-09 | ボディが任意（required: false） | E-01 (body.required: false) | ○ |
| C-10 | idsクエリパラメータの存在 | E-01 (params.ids) | ○ |
| C-11 | 関連機能No.30（TermVectors API） | E-05 | ○ |
| C-12 | term_statistics等のパラメータはテンプレートとして機能 | E-01 (description記載), E-02 (行80) | ○ |
| C-13 | Strings.commaDelimitedListToStringArrayによるID解析 | E-02 (行81) | ○ |
| C-14 | TransportMultiTermVectorsActionの並列実行動作 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- TransportMultiTermVectorsActionの内部実装（シャードベースの並列実行、結果集約）は追跡していない
  - 候補：TransportMultiTermVectorsAction.java

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - REST API定義とハンドラの整合性は高い
- 0: 低リスク - Term Vectors APIとのコード共有パターンは正確に記載

## 6) レビュアーチェックリスト（最小）
- [ ] C-14: TransportMultiTermVectorsActionの実行パターン（シャードベース or 逐次）を確認
- [ ] docs配列内の個別パラメータ指定がテンプレートを正しく上書きするか確認
- [ ] エラー時の各ドキュメントのレスポンス構造を確認
